<?php

if (!defined('PLX_ROOT')) exit;

# Control du token du formulaire
plxToken::validateFormToken($_POST);

$params = array('activate' => 'checkbox', 'profil'=>'select');

if (! empty($_POST)) {
	foreach ($params as $field=>$type) {
		$value =  (isset($_POST[$field])) ? intval($_POST[$field]) : 0;
		$plxPlugin->setParam($field, $value, 'numeric');
	}
	$plxPlugin->saveParams();
	header('Location: '.basename($_SERVER['REQUEST_URI']));
	exit;
}
	
# Tableau des profils
$aProfils = array(
	PROFIL_ADMIN => L_PROFIL_ADMIN, // can moderate everything
	PROFIL_MANAGER => L_PROFIL_MANAGER, // can moderate static pages
	PROFIL_MODERATOR => L_PROFIL_MODERATOR, // can moderate comments
	PROFIL_EDITOR => L_PROFIL_EDITOR, // can moderate categories
	PROFIL_WRITER => L_PROFIL_WRITER // can moderate only articles
);
?>
	<p>
		<?php echo $plxPlugin->lang('L_'.strtoupper($plugin.'_infos')); ?>
	</p>
	<form method="post" id="controlCSS_id">
	<?php echo plxToken::getTokenPostMethod()."\n"; ?>
<?php
	foreach ($params as $field=>$type) {
		$value = intval($plxPlugin->getParam($field));
		$id =  'id_'.$field; ?>
		<p>
			<label for="<?php echo $id; ?>"><?php $plxPlugin->lang('L_'.strtoupper($plugin).'_'.strtoupper($field)); ?></label>
<?php
		switch ($type) {
			case 'checkbox' :
				$checked =  ($value > 0) ? ' checked' : ''; ?>
			<input type="checkbox" id="<?php echo $id; ?>" name="<?php echo $field; ?>" value="1"<?php echo $checked; ?> />
<?php
				break;
			case 'select' : ?>
<?php plxUtils::printSelect($field, $aProfils, $value); ?>
<?php
				break;
		} ?>
		</p>
<?php
	}
?>		<p>
			<label>&nbsp;</label>
			<input type="submit" value="<?php $plxPlugin->lang(L_CSSCONTROL_SAVE); ?>"/>
		</p>
	</form>
	
