<?php

/*
 * plugin cssControl pour Pluxml 5.4
 * Rajoute une entrée dans le menu d'administration pour forcer la regénération
 * des caches des feuilles de style CSS des plugins.
 * Utilise un cookie de session.
 * @author: J.P. Pourrez
 * @lastdate: 2015-10-25
 * */

define('CACHE_CSS', 'cache-css');
define('CACHE_CSS_GET', 'control_css');

function cacheCSS_update() {
	//vérifie si le cache CSS doit être regénéré
	return (isset($_SESSION['profil']) and isset($_SESSION[CACHE_CSS]) and ($_SESSION[CACHE_CSS] == 1));
}

if (isset($_GET[CACHE_CSS_GET])) {
	if ($_GET[CACHE_CSS_GET] == filemtime(__FILE__)) {
		// mémorise l'action sur le bouton dans le menu d'admin dans la session
		session_start();
		if (cacheCSS_update()) 
			$_SESSION[CACHE_CSS] = 0;
		else 
			$_SESSION[CACHE_CSS] = 1;
		header('Location: '.$_SERVER['HTTP_REFERER']);
	}
	exit;
}

if (!defined('PLX_ROOT')) exit;

class cssControl extends plxPlugin {

	public function __construct($default_lang) {
		# appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);

		# droits pour accéder à la page config.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);

		$this->addHook('AdminTopMenus', 'AdminTopMenus');
		$this->addHook('AdminPrepend', 'updateCache');
		$this->addHook('Index', 'updateCache');
		$this->addHook('AdminTopEndHead', 'AdminTopEndHead');
	}

	public function updateCache() {
		global $plxAdmin;
		if ($this->getParam('activate') and cacheCSS_update()) {
			if (isset($plxAdmin)) {
				// On est dans le back-office
				$plxAdmin->plxPlugins->cssCache('admin');
			} else {
				// On est en publication
				global $plxMotor;
				if (isset($plxMotor))
					$plxMotor->plxPlugins->cssCache('site');
			}			
		}
	}
	
	public function OnActivate() {
		$this->setParam('activate', 1, 'numeric');
		$this->setParam('profil', PROFIL_MANAGER, 'numeric');
		$this->saveParams();
	}
	
	// ajoute une entrée au menu dans la partie Admin
	public function AdminTopMenus() {
		global $plxAdmin;
		
		if (($this->getParam('activate') == 1) and ($_SESSION['profil'] <= $this->getParam('profil'))) {
			global $menus;
			
			$href = $plxAdmin->racine.$plxAdmin->aConf['racine_plugins'];
			$href .= __CLASS__.'/'.basename(__FILE__).'?'.CACHE_CSS_GET.'='.filemtime(__FILE__);
			$title = (cacheCSS_update()) ? 'Mise à jour du cache CSS forcée' : 'Mise à jour du cache CSS désactivée';
			$class = (cacheCSS_update()) ? 'cacheCSSoff' : false;
			$menus[] = plxUtils::formatMenu(
				plxUtils::strCheck($this->getInfo('title')),
				$href, $title, $class
			);
		}
	}
	
	public function AdminTopEndHead() {
		
		if ($this->getParam('activate') == 1) {
			header('Cache-Control: no-store, no-cache, must-revalidate'); ?>
			<style type="text/css">
				.cacheCSSoff {background-color: red;}
			</style>
<?php	}
	}

}
?>
